from django.conf.urls.defaults import patterns
from django.http import HttpResponse
from django.template import RequestContext, Template

template = """
<script src="//yandex.st/jquery/1.6.2/jquery.min.js"></script>
<script>
$(function() {
    $('#ajax_get, #ajax_post').click(function(e) {
        e.preventDefault();
        var id = this.id;
        $.ajax({
            //type: (id == 'ajax_post') ? 'POST' : 'GET',
            type: 'POST',
            url: '/ajax/',
            cache: false,
            data: {csrfmiddlewaretoken: '{{ csrf_token }}'},
            success: function(data) {alert(data);},
            error: function(e) {alert(e.status);}
        });
    });
});
</script>
HTTP_REFERER: {{ request.META.HTTP_REFERER }}<br>
HTTP_HOST: {{ request.META.HTTP_HOST }}<br>
<a href="">Get referer</a><br>
<a href="" id="ajax_get">Ajax GET request</a>
<a href="" id="ajax_post">Ajax POST request</a>
"""

def index(request):
    t = Template(template)
    return HttpResponse(t.render(RequestContext(request, {'request': request})))

def ajax(request):
    return HttpResponse('HTTP_REFERER: %s\nHTTP_HOST: %s' % (request.META.get('HTTP_REFERER', ''), request.META['HTTP_HOST']))

urlpatterns = patterns('',
    (r'^$', index),
    (r'^ajax/$', ajax),
)
