from django.db import models

class Person(models.Model):
    firstname = models.CharField(max_length=100)
    lastname = models.CharField(max_length=100)
    number_of_dogs = models.IntegerField()
    zip_code = models.CharField(max_length=5)

    def __unicode__(self):
        return u'%s %s' % (firstname, lastname)
    
    
class Pet(models.Model):
    name = models.CharField(max_length=100)
    breed = models.CharField(max_length=100)
    birthdate = models.DateField()

    def __unicode__(self):
        return u'%s' % self.name
    
class Collar(models.Model):
    collar_code = models.CharField(max_length=5, primary_key=True)
    pet = models.ForeignKey(Pet)

    def __unicode__(self):
        return u'%s' % self.collar_code
