"""

"""
from testapp.models import Person
from django.test import TestCase


class TestFixtureLoading(TestCase):
    """
    Each fixture file contains One Person.
    This should load the one into default only.
    """
    multi_db = True

    fixtures = ['people.default.json']

    def test_fixtures_loaded_to_default(self):
        """
        This is the only test that does not fail
        """
        persons = Person.objects.all()
        self.assertEqual(len(persons), 1)
        self.assertEqual(persons[0].lastname, "Keith-McGee")

    def test_fixtures_loaded_to_core(self):
        """
        Should load no data to core, but does
        """
        persons = Person.objects.using('core').all()
        self.assertEqual(len(persons), 0)

class TestFixtureLoadingWithNoMultiDBSet(TestCase):
    """
    Each fixture file contains One Person.
    This should load the one into default only.
    """

    fixtures = ['people.default.json']

    def test_fixtures_loaded_to_default(self):
        """
        This is the only test that does not fail
        """
        persons = Person.objects.all()
        self.assertEqual(len(persons), 1)
        self.assertEqual(persons[0].lastname, "Keith-McGee")

    def test_fixtures_loaded_to_core(self):
        """
        Should load no data to core, but does
        """
        persons = Person.objects.using('core').all()
        self.assertEqual(len(persons), 0)



class TestFixtureLoadingForMultipleDbs(TestCase):
    """
    Each fixture contains one person Object.
    Should load one fixture to each db
    """
    multi_db = True

    fixtures = ['people.default.json', 'morepeople.core.json']

    def test_fixtures_loaded_to_default(self):
        """
        One person should be loaded to default, but isn't
        Both objects are loaded
        """
        persons = Person.objects.all()
        self.assertEqual(len(persons), 1)
        


    def test_fixtures_loaded_to_core(self):
        """
        One person should be loaded to core, but isn't
        Both are loaded into core
        """
        persons = Person.objects.all()
        self.assertEqual(len(persons), 1)


