#!/usr/bin/env python

class UnicodeContainer:

    def __init__(self, unicode):
        self._unicode = unicode

    def __str__(self):
        raise TypeError("string coercion on non bytestream")

    def __unicode__(self):
        return self._unicode

class LazyUnicodeContainer(UnicodeContainer):
    def __init__(self, function, *args, **kwargs):
        self._function = function
        self._args = args
        self._kwargs = kwargs

    def __unicode__(self):
        if not hasattr(self, '_unicode'):
            self._unicode = self._function(*self._args, **self._kwargs)
        return self._unicode

class LazyUnicodeDispatcher:

    def __init__(self, function):
        self._function = function

    def __call__(self, *args, **kwargs):
        return LazyUnicodeContainer(self._function, *args, **kwargs)

def test_function(message):
    print "Calling ugettext"
    return message.decode('utf-8')

print "Setting up the LazyUnicodeDispatcher"
lazy_unicode_dispatcher = LazyUnicodeDispatcher(test_function)

print "Calling the LazyUnicodeDispatcher"
lazy_unicode_container = lazy_unicode_dispatcher('\xc2\xbfQu\xc3\xa9 pasa?')

print "Converting the LazyUnicodeContainer"
unicode_value = unicode(lazy_unicode_container)

print "Printing results:"
print "    %s" % type(unicode_value)
print "    %s" % unicode_value
