from django.core.management import setup_environ
import settings
setup_environ(settings)

from obj_creation_speed.models import T1,T2,T3
from django.db.transaction import commit_on_success

from datetime import datetime

@commit_on_success
def managed():
    """
    Uncomment me to create some DB data...
    T1.objects.all().delete()
    T2.objects.all().delete()
 
    for i in range(0, 10000):
        if i % 1000 == 0:
             print '.',
        T1(id=i).save()
        t2 = T2(id=i)
        for k in range(1,11):
            setattr(t2,'f%d' %k, str(k))
        t2.save()
    """
    from django.db import connection
    total = datetime.now() - datetime.now()
    cursor = connection.cursor()
    for j in range(0, 100):
        start = datetime.now()
        #Test for raw query speed 
        #cursor.execute("select * from foobar_t1")
        #lst = list(cursor.fetchall()) 
        
        #Test for DB fetch speed
        #list(T1.objects.all())
        
        # And just loop & create
        for k in range(0,10000):
            T1(k)
            # T2(k, k, k, k, k, k, k, k, k, k, k)
        total +=  datetime.now() - start
        print 'Loop %d, used %s' % (j, datetime.now() - start)
    print 'Total: %s' % total

if __name__ == '__main__':
    managed()
