from django import template
from django.template.defaultfilters import stringfilter
from django.utils.safestring import mark_safe

register = template.Library()

@register.filter
@stringfilter
def tabindex(widget, index):
    if isinstance(index, int):
        if widget.find('/>') != -1:
            retval = widget.replace('/>', ' tabindex="{0}" />'.format(index))
            return mark_safe(retval)
        elif widget.find('>') != -1:
            retval = widget.replace('>', ' tabindex="{0}">'.format(index))
            return mark_safe(retval)
        else:
            return mark_safe(widget)

    try:
        ind = int(index)
        return tabindex(widget, index)
    except:
        return mark_safe(widget)
tabindex.is_safe = True
