from django.conf import settings
from django.core.urlresolvers import reverse
from django.test import TestCase
from django.conf import urls as url_handlers
from django.template import Context, Template
from django.contrib.messages.tests import urls
from django import http
from django.test.utils import override_settings
from django.contrib.messages import constants
from django.contrib.messages.api import MessageFailure


class Test500(TestCase):

    def render_error(self, *args, **kw):
        error_template = Template("{% url about-site %}")
        # This template will work, because it doesn't do a reverse match on 
        # on something on the destroyed ROOT_URLCONF.
        #error_template = Template("works")
        return http.HttpResponse(error_template.render(Context({})))

    # These are the override_settings defined in the contrib/messages/tests/base.py,
    # copied here so you don't get lead astray
    @override_settings(
        INSTALLED_APPS=filter(
            lambda app:app!='django.contrib.messages', settings.INSTALLED_APPS),
        MIDDLEWARE_CLASSES=filter(
            lambda m:'MessageMiddleware' not in m, settings.MIDDLEWARE_CLASSES),
        TEMPLATE_CONTEXT_PROCESSORS=filter(
            lambda p:'context_processors.messages' not in p,
                 settings.TEMPLATE_CONTEXT_PROCESSORS),
        MESSAGE_LEVEL=constants.DEBUG
    )
    def test_error_handling_page(self):
        # This is the key here. This is done in django/test/testcases.py _urlconf_setup.
        # Where the url conf is overridden in the test.
        settings.ROOT_URLCONF = urls
        # When the client has a problem and raises the 500 message down below, it will
        # propogate up the handler 500 specified here.
        url_handlers.handler500 = self.render_error
        show_url = reverse('django.contrib.messages.tests.urls.show')
        add_url = reverse('django.contrib.messages.tests.urls.add', args=('warning',))
        data = {
            'messages': ['Test message %d' % x for x in xrange(10)],
        }
        # This is copied from contrib/messages/tests/base.py and will raise a MessageFailure error
        # 
        # So really the problem is that we are testing the propogation into the 500 handler
        # as well. We shouldn't be doing all that, what we should be doing is the following.
        # Then render_error never gets called.
        #settings.DEBUG = True
        #settings.DEBUG_PROPAGATE_EXCEPTION = True
        self.assertRaises(MessageFailure, self.client.post, add_url, data, follow=True)
