from django.db import models


class SiteManager(models.Manager):
    def get_by_domain(self, domain):
        domain = domain.split(':')[0]
        return self.select_related().get(domain__exact=domain)

    def get_current(self, request):
        try:
            http_host = request.META['HTTP_HOST']
        except KeyError:
            http_host = ''
        return self.get_by_domain(http_host)

class Site(models.Model):
    domain = models.CharField(unique=True, max_length=100, db_index=True)

    objects = SiteManager()

    class Meta:
        db_table = 'sites'
