#coding=utf-8
from django.utils.safestring import mark_safe
from django.utils.encoding import force_unicode   
from django.forms.widgets import SelectMultiple,CheckboxInput
from itertools import chain
from django.utils.html import conditional_escape

class CheckboxMultiWidget(SelectMultiple):
    def render(self, name, value, attrs=None, choices=()):
        if value is None: value = []
        has_id = attrs and 'id' in attrs
        final_attrs = self.build_attrs(attrs, name=name)
        output = [u'<span>']
        # start modified code
        if value:
            str_values = set([v for v in eval(value)])
        else:
            str_values = set([v for v in value])
        # end modified code
        for i, (option_value, option_label) in enumerate(chain(self.choices, choices)):
            if has_id:
                final_attrs = dict(final_attrs, id='%s_%s' % (attrs['id'], i))
                label_for = u' for="%s"' % final_attrs['id']
            else:
                label_for = ''

            cb = CheckboxInput(final_attrs, check_test=lambda value: value in str_values)
            option_value = force_unicode(option_value)
            rendered_cb = cb.render(name, option_value)
            option_label = conditional_escape(force_unicode(option_label))
            output.append(u'<label%s>%s %s &nbsp;&nbsp;&nbsp;</label>' % (label_for, rendered_cb, option_label))
        output.append(u'</span>')
        return mark_safe(u'\n'.join(output))

    def id_for_label(self, id_):
        # See the comment for RadioSelect.id_for_label()
        if id_:
            id_ += '_0'
        return id_
    id_for_label = classmethod(id_for_label)
