import os
os.environ.setdefault('DJANGO_SETTINGS_MODULE', 'lookup_hstore_test.settings')
from testproject.models import TestModel
TestModel.objects.all().delete()
TestModel(data={'an_int': '23', 'b': 'foobar'}).save()
TestModel(data={'an_int': '43', 'b': 'foobar'}).save()
# Lets do some casting...
TestModel.objects.filter(data__an_int__as_int__lte=40)
# Testing the nested_hstore thingy - this ain't pretty but shows the
# generality of nested lookups
TestModel(data={'nested_hstore': 'an_int=>3'}).save()
print(TestModel.objects.filter(
    data__nested_hstore__as_hstore__an_int__as_int__lte=40))
# The hcontains lookup
print(TestModel.objects.filter(data__dj_hcontains='an_int'))
print(TestModel.objects.filter(data__dj_hcontains='asdf'))
# This uses Django's regular contains lookup for data as text.
print(TestModel.objects.filter(data__dj_contains='an_int'))
