from django.utils import unittest
from django.test import client
from django.db.models import Q

from models import A, Tag

class TestCreateMessageLog(unittest.TestCase):
    @classmethod
    def setUp(cls):
        t1 = Tag(value='T1')
        t1.save()
        t2 = Tag(value='T2')
        t2.save()
        a1 = A(name='A1')
        a1.save()
        a1.tags.add(t1)
        a1.tags.add(t2)
        a1.save()
        a2 = A(name='A2')
        a2.save()
        a2.tags.add(t1)
        a2.save()
        a3 = A(name='A3')
        a3.save()

    def testFilterAndOnSameRelatedField(self):
        q1 = Q(tags__value__iexact='T1')
        q2 = Q(tags__value__iexact='T2')
        f = A.objects.filter(q1 & q2)

        # a1 should have been selected because it has both tag t1 and t2
        self.assertEqual(1, len(f), 'The wrong number of items were selected (was {0} instead of 1)'.format(len(f)))
        self.assertEqual(u'A1', f[0].name, 'The wrong item was selected ({0} instead of A1)'.format(f[0].name))
