import datetime
from django.db import models
from django.contrib.auth.models import User, AnonymousUser, UserManager

class Poll(models.Model):
    question = models.CharField(max_length=200)
    pub_date = models.DateTimeField('date published')
    def __unicode__(self):
            return self.question

    def was_published_today(self):
            return self.pub_date.date() == datetime.date.today()

    was_published_today.short_description = 'Published today?'


class Choice(models.Model):
    poll = models.ForeignKey(Poll)
    choice = models.CharField(max_length=200)
    votes = models.IntegerField()
    def __unicode__(self):
            return self.choice


class ExUser(User):
    class Meta:
        proxy = True

    def foo():
        pass


class Profile(models.Model):
    user = models.ForeignKey(ExUser)
    nick = models.CharField(max_length=200)

    def __unicode__(self):
            return "id=%d, nick=%s" % (self.id, self.nick)


