from django.db import models
from django.db.models import Q
from django.db import connection

# Create your models here.
class Group(models.Model):
    name = models.CharField(max_length=100)
    activity_category = models.ForeignKey('ActivityCategory', null=True, blank=True, )

    def __str__(self, ):
        return "%s (cat=%s)" % (self.name, self.activity_category_id, )


class ActivityCategory(models.Model):
    name = models.CharField(max_length=50)

    def __str__(self, ):
        return self.name

def test():
    qobj = Q(activity_category__name='Dorm') | Q(activity_category__name='Dorm')
    qex = Group.objects.exclude(qobj)
    print "or'd/exclude", list(qex)
    queryset = Group.objects.filter(~qobj)
    print "or'd/filter", list(queryset)
    queryset = Group.objects.filter(~Q(qobj))
    print "or'd/filterout", list(queryset)
    queryset = Group.objects.filter(Q(~qobj))
    print "or'd/filterin", list(queryset)

    qobj = Q(activity_category__name='Dorm')
    qex = Group.objects.exclude(qobj)
    print "single/exclude", list(qex)
    queryset = Group.objects.filter(~qobj)
    print "single/filter", list(queryset)
    queryset = Group.objects.filter(~Q(qobj))
    print "single/filterout", list(queryset)
    queryset = Group.objects.filter(Q(~qobj))
    print "single/filterin", list(queryset)
    
    print ""
    for query in connection.queries:
        print query['sql']
