
class ToolDBRouter(object):
    """The db router for all classes in the station and catalog db's"""

    def db_for_read(self, model, **hints):
        """if app label is matcher then point to station or catalog slave db"""
        if model.__name__.startswith('Station'):
            return 'station'
        if model.__name__.startswith('Catalog'):
            return 'catalog'
        return None

    def db_for_write(self, model, **hints):
        """if app label is matcher then point to station or catalog master db"""
        if model.__name__.startswith('Station'):
            return 'station'
        if model.__name__.startswith('Catalog'):
            return 'catalog'
        return None

    def allow_syncdb(self, db, model):
        """Make sure the catalog and station tables only appear on catalog and station db's"""
        value = None
        if db == 'station':
            if model.__name__.startswith('Station'):
                value = True
            elif model.__name__.startswith('Catalog'):
                value = False
        elif db == 'catalog':
            if model.__name__.startswith('Catalog'):
                value = True
            elif model.__name__.startswith('Station'):
                value = False
        elif model.__name__.startswith('Catalog') or model.__name__.startswith('Station'):
                value = False

        #print 'tool: {0} / {1} / {2} / {3}'.format(db, model._meta.app_label, model.__name__, value)
        return value

    def allow_relation(self, obj1, obj2, **hints):
        print 'allow relationship {0} to {1}'.format(obj1, obj2)
        return None
