
class WallDBRouter(object):
    """The db router for thewall classes"""
    def __init__(self):
        self.db_list = ('default','slave')

    def db_for_read(self, model, **hints):
        """set to default for now so unit tests will pass"""
        return 'slave'

    def db_for_write(self, model, **hints):
        return 'default'

    def allow_relation(self, obj1, obj2, **hints):
        "Allow any relation between two objects in the db pool"
        if obj1._state.db in self.db_list and obj2._state.db in self.db_list:
            return True
        return None

    def allow_syncdb(self, db, model):
        """We are the last db, so default to yes"""
        return db == 'default'
