# Embed a dummy URLconf to make the test self-contained
from django.conf.urls.defaults import patterns, include, url
from django.http import HttpResponse
urlpatterns = patterns('',
    url(r'', lambda request: HttpResponse('')),
)


from django.test import TestCase
from django.test.client import RequestFactory


class TestViews(TestCase):

    urls = __name__

    def setUp(self):
        self.factory = RequestFactory()

    def common_test_that_should_always_pass(self):
        request = self.factory.get('/')
        request.session = {}
        self.assertFalse(hasattr(request, 'user'))

    def test_request(self):
        self.common_test_that_should_always_pass() # OK

    def test_request_after_client(self):
        # apart from the next line the three tests are identical
        self.client.get('/')
        self.common_test_that_should_always_pass() # FAIL

    def test_request_after_client_2(self):
        # This test is executed after the previous one thus also fails
        self.common_test_that_should_always_pass() # FAIL

