from django.test.client import RequestFactory
from django.test import TestCase

class TestViews(TestCase):
    def setUp(self):
        self.factory = RequestFactory()

    def test_request(self):
        request = self.factory.get('/')
        self.assertFalse(hasattr(request, 'user')) # OK

    def test_request_after_client(self):
        self.client.get('/')

        request = self.factory.get('/')
        request.session = {}
        self.assertFalse(hasattr(request, 'user')) # FAIL

    def test_request_after_client_2(self):
        # This test is executed after the previous one thus also fails
        request = self.factory.get('/')
        request.session = {}
        self.assertFalse(hasattr(request, 'user')) # FAIL

