import logging
from logging.handlers import SMTPHandler
from django.test import TestCase

class DjangoCoreTests(TestCase):
    def setUp(self):
        self.log = logging.getLogger('test.logger')


    def test_correct_host(self):
        for h in self.log.handlers:
            if isinstance(h, SMTPHandler):
                self.assertEquals(h.mailhost, "mailhost.test")


    def test_correct_port(self):
        for h in self.log.handlers:
            if isinstance(h, SMTPHandler):
                self.assertEquals(h.mailport, 321)


    def test_correct_username(self):
        for h in self.log.handlers:
            if isinstance(h, SMTPHandler):
                self.assertEquals(h.username, "testuser1")


    def test_correct_password(self):
        for h in self.log.handlers:
            if isinstance(h, SMTPHandler):
                self.assertEquals(h.password, "testpassword1")
