#coding: utf-8

from django import forms
from django.contrib.contenttypes import generic
from django.contrib import admin

from bug.models import MainModel, Inline1, Inline2

class Inline1Form(forms.models.ModelForm):
    class Meta:
        model   = Inline1
        exclude = ('inline1_field2', )

class Inline2Form(forms.models.ModelForm):
    class Meta:
        model   = Inline2
        exclude = ('inline2_field2',)

class Inline1Inline(admin.StackedInline):
    model = Inline1
    form  = Inline1Form
    extra = 1

class Inline2Inline(generic.GenericStackedInline):
    model = Inline2
    form  = Inline2Form
    extra = 1

class MainModelAdmin(admin.ModelAdmin):
    inlines = (Inline1Inline, Inline2Inline)

admin.site.register(MainModel, MainModelAdmin)

