
dcls = {
 'eventmaintenance' : EventMaintenance,
 'eventfailure'     : EventFailure,
 'eventmakingorder' : EventMakingOrder,
 'eventmethod'      : EventMethod,
 'eventcustom'      : EventCustom,
}

# after a form post
def foo(cleaned_data):

    ev_type = cleaned_data.get('event_type')
    dcls.get(ev_type, Event)

    if cls == Event:
        model_list = [EVENT_MAINTENANCE, EVENT_FAILURE, EVENT_MAKINGORDER, EVENT_METHOD, EVENT_CUSTOM]
        ct_list = ContentType.objects.filter(model__in=model_list)
        queryset = Event.objects.all().filter(content_type__in=ct_list)
    else:
        queryset = cls.objects.all()


    # cls._meta.get_field_by_name('description')
    # description: [method | custom | failure | maintenance]
    # no description: [event_channel | eventmakingorder]
    event_descr_filter = Q()
    models_description = [ EventMethod, EventCustom, EventMaintenance ]
    # pb is: if Event is here, we won't be able to access EventFailure directly, but only through Channel
    event_failure_through_event = EventChannel._meta.module_name + '__' + EventFailure._meta.module_name
    if cls in [Event] + models_description + [EventFailure]:
        if cls != Event:
            event_descr_filter = Q(description__icontains=name_descr)
        else: # filter on all
            iterable = [{m._meta.module_name+'__description__icontains': name_descr} for m in models_description]
            iterable.append({event_failure_through_event + '__description__icontains': name_descr})
            event_descr_filter = reduce(lambda cumul, d: cumul | Q(**d), iterable[1:], Q(**iterable[0]))

    # OpClass: Event => Operation, EventMaintenance => Maintenance, etc.
    op_filter = Q()
    opClass = cls.get_associated_operation_cls()
    # Only for Event* class that have an associated Operation
    if opClass:
        import pdb; pdb.set_trace()
        f = lambda x: Q(**{x+'__name__icontains':name_descr}) | Q(**{x+'__description__icontains':name_descr})
        if cls != Event:
            op_filter = f(opClass._meta.module_name)
        else:
            iterable = [f(m._meta.module_name + "__" + m.get_associated_operation_cls()._meta.module_name)
                        for m in models_description if m.get_associated_operation_cls()]
            iterable.append(f(event_failure_through_event + "__" + EventFailure.get_associated_operation_cls()._meta.module_name))
            op_filter = reduce(lambda cumul, q: cumul | q, iterable)

    queryset = queryset.filter(event_descr_filter | op_filter)
