from django.db import models

class Policy(models.Model):
    policy_number = models.CharField(max_length=10)

class Version(models.Model):
    policy = models.ForeignKey(Policy)

class Location(models.Model):
    version = models.ForeignKey(Version, blank=True, null=True)

class Item(models.Model):
    version = models.ForeignKey(Version)
    location = models.ForeignKey(Location, blank=True, null=True)

class ItemRateCode(models.Model):
    item = models.ForeignKey(Item)

class PropertyItem(models.Model):
    item_rate_code = models.ForeignKey(ItemRateCode)

class Coverage(models.Model):
    version = models.ForeignKey(Version)
    item_rate_code = models.ForeignKey(ItemRateCode)


"""
# simple example to show bug...

from myapp.models import Policy, Version, Location, Item
from myapp.models import ItemRateCode, PropertyItem, Coverage

policy = Policy.objects.create(pk=1, policy_number="1234")
version = Version.objects.create(policy=policy)
location = Location.objects.create(version=version)

item1 = Item.objects.create(version=version, location=location)
item2 = Item.objects.create(version=version, location=location)

# one for each item
item_rate_code1 = ItemRateCode.objects.create(item=item1)
item_rate_code2 = ItemRateCode.objects.create(item=item2)

# one for each item_rate_code
coverage1 = Coverage.objects.create(version=version, item_rate_code=item_rate_code1)
coverage2 = Coverage.objects.create(version=version, item_rate_code=item_rate_code2)

# one for each item_rate_code
property_item1 = PropertyItem.objects.create(item_rate_code=item_rate_code1)
property_item2 = PropertyItem.objects.create(item_rate_code=item_rate_code2)

policy = Policy.objects.get(pk=1)
policy.delete()

"""
