

from django.test import TestCase

from myapp.models import Policy, Version, Location, Item
from myapp.models import ItemRateCode, PropertyItem, Coverage

class DeletePolicyTests(TestCase):

    def setup_models(self):

        policy = Policy.objects.create(pk=1, policy_number="1234")
        version = Version.objects.create(policy=policy)
        location = Location.objects.create(version=version)

        item1 = Item.objects.create(version=version, location=location)
        item2 = Item.objects.create(version=version, location=location)

        # one for each item
        item_rate_code1 = ItemRateCode.objects.create(item=item1)
        item_rate_code2 = ItemRateCode.objects.create(item=item2)

        # one for each item_rate_code
        Coverage.objects.create(version=version, item_rate_code=item_rate_code1)
        Coverage.objects.create(version=version, item_rate_code=item_rate_code2)

        # one for each item_rate_code
        PropertyItem.objects.create(item_rate_code=item_rate_code1)
        PropertyItem.objects.create(item_rate_code=item_rate_code2)

    def test_deletes_policy_successfully(self):
        self.setup_models()
        policy = Policy.objects.get(pk=1)
        self.assertEqual(None, policy.delete())
        self.assertEqual(0, len(Policy.objects.all()))
        