# -*- coding: utf-8 -*-
from django.db import models
from django.db.models import Sum
from django.core.exceptions import ObjectDoesNotExist
from datetime import *
from decimal import *


class Kostenstelle(models.Model):
    id   = models.AutoField(primary_key=True)
    name = models.CharField(max_length=60, blank=True)

    class Meta:
        db_table = u'kostenstelle'


class Code(models.Model):
    id        = models.BigIntegerField(primary_key=True)
    text      = models.CharField(max_length=60, blank=True)
    grenzwert = models.DecimalField(null=True, max_digits=5, decimal_places=2, blank=True)

    class Meta:
        db_table = u'code'


class Mitarbeiter(models.Model):
    id          = models.AutoField(primary_key=True)
    key         = models.CharField(max_length=10, unique=True)

    geburtstag  = models.DateField()
    eintritt    = models.DateField()
    sperre      = models.DateField(null=True, blank=True)

    name        = models.CharField(max_length=80)
    vorname     = models.CharField(max_length=80)
    code        = models.ForeignKey(Code, db_column='code')

    class Meta:
        db_table = u'mitarbeiter'
        ordering = ['name', 'vorname']


class Status(models.Model):
    id         = models.AutoField(primary_key=True)
    status     = models.CharField(max_length=45, blank=True)
    statustext = models.CharField(max_length=8, blank=True)

    class Meta:
        db_table = u'status'
        ordering = ['id']


class Erfasst(models.Model):
    id           = models.AutoField(primary_key=True)
    key          = models.ForeignKey(Mitarbeiter, db_column='key', to_field='key')

    datum        = models.DateField()
    code         = models.ForeignKey(Code, db_column='code')
    status       = models.ForeignKey(Status, db_column='status')
    realkst      = models.ForeignKey(Kostenstelle, db_column='realkst')

    class Meta:
        db_table = u'erfasst'
