(function($) {
        
    $.fn.multiselectfilter = function (params) {
        return this.each(function () {
            var field_id = this.id;
            if (this.id.match(/__prefix__/)){
                // Don't intialize on empty forms.
                return;
            }
            var from_box = $(this);
            var from = this;
            this.id += '_from';
            this.className = 'filtered';
            
            // Remove <p class="info">, because it just gets in the way.
            from_box.parent().find('p').remove();
            
            // <div class="selector"> or <div class="selector stacked">
            var selector_div = $('<div/>').appendTo(from_box.parent());
            selector_div.addClass('selector');
            if (params.stacked) {
                selector_div.addClass('stacked');
            }
            var hidden = $('<div/>');

            // <div class="selector-available">
            var selector_available = $('<div><h2>'+interpolate(gettext('Available %s'), [params.verbose_name])+'</h2></div>').appendTo(selector_div);
            selector_available.addClass('selector-available');
            var filter_p = $('<p><img src="'+params.admin_media_prefix+'img/admin/selector-search.gif" /> </p>').appendTo(selector_available);
            filter_p.addClass('selector-filter');
            var filter_input = $('<input type="text" id="'+field_id+'_input" />').appendTo(filter_p);
            from_box.appendTo(selector_available);
            var choose_all = $('<a href="#">'+gettext('Choose all')+'</a>').appendTo(selector_available);
            choose_all.addClass('selector-chooseall');

            // <ul class="selector-chooser">
            var selector_chooser = $('<ul/>').appendTo(selector_div);
            selector_chooser.addClass('selector-chooser');
            var add_link = $('<a href="#">'+gettext('Add')+'</a>').appendTo($('<li/>').appendTo(selector_chooser));
            add_link.addClass('selector-add');
            var remove_link = $('<a href="#">'+gettext('Remove')+'</a>').appendTo($('<li/>').appendTo(selector_chooser)); 
            remove_link.addClass('selector-remove');

            // <div class="selector-chosen">
            var selector_chosen = $('<div><h2>'+interpolate(gettext('Chosen %s'), [params.verbose_name])+'</h2></div>').appendTo(selector_div);
            selector_chosen.addClass('selector-chosen');
            var selector_filter = $('<p>'+gettext('Select your choice(s) and click ')+'<img src="'+params.admin_media_prefix + (params.stacked ? 'img/admin/selector_stacked-add.gif':'img/admin/selector-add.gif')+'" alt="Add" /></p>').appendTo(selector_chosen);
            selector_filter.addClass('selector-filter');
            var to_box = $('<select id="'+field_id + '_to" multiple="multiple" size="'+from.size+'" name="'+from.name+'" />').appendTo(selector_chosen);
            to_box.addClass('filtered');
            var clear_all = $('<a href="#">'+gettext('Clear all')+'</a>').appendTo(selector_chosen);
            clear_all.addClass('selector-clearall');
            
            from.name += '_old';
            
            function move(from_box, to_box) {
                from_box.find('option[selected]').appendTo(to_box).removeAttr('selected');
                to_box.focus();
            };
            
            choose_all.click(function () {
                from_box.find('option').appendTo(to_box);
            });
            clear_all.click(function () {
               to_box.find('option').appendTo(from_box); 
            });
            add_link.click(function (e) { move(from_box, to_box); e.preventDefault(); });
            remove_link.click(function (e) { move(to_box, from_box); e.preventDefault(); });
            from_box.dblclick(function (e) { move(from_box, to_box); e.preventDefault(); });
            to_box.dblclick(function (e) { move(to_box, from_box); e.preventDefault(); });
            from_box.parents('form').submit(function () { to_box.find('option').attr('selected', 'selected'); });
            move(from_box, to_box);
            
            filter_input.keyup(function (e) {
                // don't submit form if user pressed Enter
                if (e.which == 13) {
                    from_box.find('option[selected]').appendTo(to_box).removeAttr('selected');
                    e.preventDefault();
                    return;
                }
                var temp = from.selectedIndex;
                var tokens = filter_input.val().toLowerCase().split(/\s+/);
                if (tokens[0] == "") {
                    hidden.find('option').each(function () {
                        $(this).appendTo(from_box);
                    });
                }
                var node, token;
                from_box.add(hidden).find('option').each(function () {
                    var opt = $(this);
                    for (var j = 0; (token = tokens[j]); j++) {
                        if (opt.text().toLowerCase().indexOf(token) == -1) {
                            opt.appendTo(hidden);
                            break;
                        } else {
                            opt.appendTo(from_box);
                        }
                    }
                });
                from.selectedIndex = temp;
                return true;
            });
            filter_input.keydown(function (e) {
                // right arrow -- move across
                if (e.which == 39) {
                    var old_index = from.selectedIndex;
                    move(from_box, to_box);
                    from.selectedIndex = (old_index == from.length) ? from.length - 1 : old_index;
                    from_box.focus();
                    e.preventDefault();
                    return;
                }
                // down arrow -- wrap around
                if (e.which == 40) {
                    from.selectedIndex = (from.length == from.selectedIndex + 1) ? 0 : from.selectedIndex + 1;
                }
                // up arrow -- wrap around
                if (e.which == 38) {
                    from.selectedIndex = (from.selectedIndex == 0) ? from.length - 1 : from.selectedIndex - 1;
                }
            });
        });
    }
    
})(django.jQuery );