from django.contrib import admin
from bug_15355.myapp import models


class AdvertisorOfficeInline(admin.StackedInline):
    model = models.AdvertisorOffice
    extra = 0
    can_delete = False
    fieldsets = (
        (None, {
                'fields': (('memo',), 
                           ('name_selected', 'name'),
                           ('short_name_selected', 'short_name'),
                           ('address_selected', 'address')),
                'description': 'Select to override the advertisor data.'
                }),
        )


class EmailAdvertisorInline(admin.TabularInline):
    model = models.EmailAdvertisor
    extra = 1

class AdvertisorAdmin(admin.ModelAdmin):
    fieldsets = (
        (None, {
            'fields': (('memo',), 
                       ('name', 'short_name',),
                       'address'),
            }),
        ('Authentification', {
            'fields': ('login', 'password')
            }),
        )
    inlines = [
        AdvertisorOfficeInline,
        EmailAdvertisorInline,
    ]


admin.site.register(models.Support)
admin.site.register(models.Advertisor, AdvertisorAdmin)
