from django.db import models
from django.contrib.sites.models import Site, SiteManager


class Support(Site):
    short_name = models.CharField(max_length=10)
    logo = models.ImageField('logo', upload_to='images/supports', blank=True)
    objects = SiteManager()


class Address(models.Model):
    name = models.CharField(max_length=200, blank=True)
    memo = models.CharField(max_length=50)
    short_name = models.CharField(max_length=200, null=True, blank=True)
    address = models.CharField(max_length=200, blank=True)

    class Meta:
        abstract = True

    def __unicode__(self):
        return '%s' % self.memo


class Advertisor(Address):
    euid = models.IntegerField(blank=True, null=True)
    login = models.CharField(max_length=30, unique=True)
    password = models.CharField(max_length=30, blank=True)


class AdvertisorOffice(Address):
    name_selected = models.BooleanField('')
    short_name_selected = models.BooleanField('')
    address_selected = models.BooleanField('')
    advertisor = models.ForeignKey(Advertisor)


TYPE_EMAIL_CHOICES = (
    ('BAT', 'BAT'),
)


class EmailAdvertisor(models.Model):
    advertisor = models.ForeignKey(Advertisor)
    address = models.ForeignKey(AdvertisorOffice, blank=True, null=True)
    support = models.ForeignKey(Support, blank=True, null=True)
    email_type = models.CharField('type', max_length=10, choices=TYPE_EMAIL_CHOICES, default='BAT')
    email = models.EmailField()
