#!/usr/bin/python
"""
django must be installed
execute this script in a functioning django environment
* Make sure DJANGO_SETTINGS_MODULE environment var is set
* Make sure the module to which it points is on python path

Then run this script on genindex.html

Take results with grain of salt; not all objects documented are meant to be imported directly
"""

import fileinput
import re

module_re = re.compile(r'href="(.*\.html)#django\.[\w.]+">(\w+)(?:\(\) \(in module| \(class in) (django\.[\w.]+)\)')
for line in fileinput.input():
    match = module_re.search(line)
    if match:
        html, obj, mod = match.groups()
        try:
            m = __import__(mod, fromlist=[obj])
            getattr(m, obj)
        except (ImportError, AttributeError):
            print "%s, %s, %s" % (html, mod, obj)
