from django.conf import settings
from django.conf.urls.defaults import * #@UnusedWildImport
from django.contrib.auth.models import User
from django.http import HttpResponse
from django.test import TestCase, Client
from django.contrib.auth.signals import user_logged_in
from django.dispatch import receiver

urlpatterns = patterns('',
    (r'^$', 'testing.tests.http_host_view'),
)

def http_host_view(request):
    return HttpResponse(request.get_host() + request.middlewares)
    
class MyMiddleware:
    def process_request(self, request):
        request.middlewares = '+middlewares'

class DjangoClientRequestTests(TestCase):
    urls = 'testing.tests'

    def setUp(self):
        u = User.objects.create(username='tester')
        u.set_password('1234')
        u.save()
        self.MIDDLEWARE_CLASSES = settings.MIDDLEWARE_CLASSES
        settings.MIDDLEWARE_CLASSES = ['testing.tests.MyMiddleware']
        
    def tearDown(self):
        settings.MIDDLEWARE_CLASSES = self.MIDDLEWARE_CLASSES
        
    def test_client_request(self):
        c = Client(HTTP_HOST='myhost.com')
        self.assertEqual(c.get("/").content, 'myhost.com+middlewares')

    def test_client_login(self):
        c = Client(HTTP_HOST='myhost.com')
        
        @receiver(user_logged_in)
        def login(sender, signal, **kwargs):
            request = kwargs.get('request', None)
            if request:
                self.assertEqual(request.get_host() + request.middlewares, 'myhost.com+middlewares') # <------ This fails
            
        c.login(username='tester', password='1234')

