from django.db import models

# Create your models here.
class Foo(models.Model):
    bars = models.ManyToManyField('Bar', through='FooBar')

    def __unicode__(self, ):
        return str(self.pk, )


class Bar(models.Model):
    slug = models.SlugField(unique=True)

    def __unicode__(self, ):
        return str(self.pk, ) + ": " + self.slug


class FooBar(models.Model):
    foo = models.ForeignKey('Foo')
    bar = models.ForeignKey('Bar', to_field='slug', )
    def __unicode__(self, ):
        return "pk=%s foo=%s bar=%s" % (str(self.pk), self.foo, self.bar, )



class Foo2(models.Model):
    bars = models.ManyToManyField('Bar2', through='FooBar2')

    def __unicode__(self, ):
        return str(self.pk, )


class Bar2(models.Model):
    slug = models.SlugField(unique=True)

    def __unicode__(self, ):
        return str(self.pk, ) + ": " + self.slug


class FooBar2(models.Model):
    foo = models.ForeignKey('Foo2')
    bar = models.ForeignKey('Bar2')
    def __unicode__(self, ):
        return "pk=%s foo=%s bar=%s" % (str(self.pk), self.foo, self.bar, )



