
from django.db import models
from django.contrib.auth.models import User
from django.db.models import signals

class SampleMain(models.Model):
	f1 = models.CharField(null=True, blank=True, max_length=100)
	num1 = models.PositiveIntegerField(null=False, blank=False, editable=True)
	num2 = models.PositiveIntegerField(null=False, blank=False,editable=True)
	class Meta:
		unique_together = ("num1", "num2")

class SampleV(models.Model):
	p = models.ForeignKey(SampleMain, editable=False)
	v = models.PositiveIntegerField(editable=False, null=False, blank=False)
	def save(self, *args, **kwargs):
		self.v = self.v+1
		super(SampleV, self).save(*args, **kwargs)

class SampleP(models.Model):
	p = models.ForeignKey(SampleMain, editable=False)
	v = models.ForeignKey(SampleV, editable=False)
	page = models.PositiveIntegerField(editable=False)

def calc_some(sender, instance, **kwargs):
	instance.num2 = instance.num2+1

signals.pre_save.connect(calc_some,sender=SampleMain)

def sample_created(sender,instance,created, **kwargs):

	v1 = SampleV(p=instance, v=1)
	v1.save()
	v2 = SampleV(p=instance, v=2)
	v2.save()

	page1 = SampleP(page=1, p=instance, v=v1)
	page1.save()
	page2 = SampleP(page=2, p=instance, v=v1)
	page2.save()
	page3 = SampleP(page=3, p=instance, v=v2)
	page3.save()

signals.post_save.connect(sample_created, sender=SampleMain)
