from django.db import models
from django.contrib.auth.models import User

class Person(models.Model):
    GENDER_CHOICES = (
        (1, "Male"),
        (2, "Female"),
    )
    name = models.CharField(max_length=100)
    gender = models.IntegerField(choices=GENDER_CHOICES)
    age = models.IntegerField(default=21)
    alive = models.BooleanField()

    def __unicode__(self):
        return self.name

    class Meta:
        ordering = ["id"]

class Employee(Person):
    code = models.CharField(max_length=20)

class WorkHour(models.Model):
    datum = models.DateField()
    employee = models.ForeignKey(Employee)
