"""
XX. Equality test for wrapper classes

Compare wrapper class instances to real objects.
"""

from django.db import models

class Article(models.Model):
    headline = models.CharField(maxlength=100, default='Default headline')
API_TESTS = '''

# Create and save an Article.
>>> u1 = Article(id=1, headline='Django 1.0 Released')
>>> u1.save()
>>> u1.id
1L

# Create and save another Article.
>>> u2 = Article(id=2, headline='Django Saves the World')
>>> u2.save()
>>> u2.id
2L

# Compare articles.
>>> u1 == u2
False

>>> u1 != u2
True

>>> u1 == u1
True

>>> u1 != u1
False

# Create ArticleWrapper objects.
>>> class ArticleWrapper(object):
...     """
...     Proxy to lazily load an article object.  Similar to
...     django.contrib.auth.middleware.UserWrapper.
...     """
...     def __init__(self, id):
...         self._id = id
...         self._cached_article = None
... 
...     def _get_article(self):
...         if not self._cached_article:
...             self._cached_article = Article.objects.get(pk=self._id)
...         return self._cached_article
... 
...     _article = property(_get_article)
... 
...     def __getattr__(self, name):
...         return getattr(self._article, name)
>>> w1 = ArticleWrapper(1) ; w2 = ArticleWrapper(2)

# Compare Article and ArticleWrapper objects.
>>> w1 == u1
True

>>> w1 != u1
False

>>> w1 == u2
False

>>> w1 != u2
True

# Compare ArticleWrapper objects.
>>> w1 == w2
False

>>> w1 != w2
True

>>> w1 == w1
True

>>> w1 != w1
False
'''
