--
-- the EPSG params for PROJ4
-- target dbms: SQLite
--


--
-- setting up a transaction
--
BEGIN;

--
-- creating the SPATIAL METADATA tables
--

SELECT InitSpatialMetaData();

--
-- populating the "spatial_ref_sys" table
--

INSERT INTO spatial_ref_sys (srid, auth_name, auth_srid, ref_sys_name, proj4text) VALUES (4326, 'epsg', 4326, 'WGS 84', '+proj=longlat +ellps=WGS84 +datum=WGS84 +no_defs');
INSERT INTO spatial_ref_sys (srid, auth_name, auth_srid, ref_sys_name, proj4text) VALUES (2393, 'epsg', 2393, 'KKJ / Finland Uniform Coordinate System', '+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=3500000 +y_0=0 +ellps=intl +towgs84=-96.0617,-82.4278,-121.743,4.80107,0.34543,-1.37646,1.4964 +units=m +no_defs');

--
-- confirming the pending transaction
--
COMMIT;

--
-- all done * job completed *
--

