from django.contrib.gis.db import models

class BaseModel (models.Model):
    id = models.AutoField(primary_key=True)
    name = models.CharField(max_length=50)
    text = models.CharField(max_length=50)
    location = models.PointField()
    
    objects = models.GeoManager()

class ProxyModel (BaseModel):
    class Meta:
        proxy = True
