from django.test import TestCase
from proxy_test.models import BaseModel, ProxyModel

class ProxyTests(TestCase):
    def setUp(self):
        #create object via the base class
        obj = BaseModel(name='test object', text='some text', location='POINT (3400000 6700010)')
        obj.save()

    def test_defer_spatial_field_on_proxy_model(self):
        #This test will fail with error
        #try to load object via the proxy 
        o = ProxyModel.objects.defer("location")[0]
        
        #try to "touch" location, make sure it gets resolved
        #now crashes with TypeError
        #TypeError: cannot set ProxyModel_Deferred_id_name_text GeometryProxy with value of type: <type 'int'>
        self.assertTrue(o.location)

    def test_defer_spatial_nonproxy(self):
        #This test is ok

        #try to load object via the base class 
        o = BaseModel.objects.defer("location")[0]

        self.assertTrue(o.location)

    def test_defer_nonspatial(self):
        #This test is ok

        #try to load object via the proxy 
        o = ProxyModel.objects.defer("text")[0]

        #location is good
        self.assertTrue(o.location)
        
        #deferred non-spatial attribute is good
        self.assertTrue(o.text)

    def test_no_defer(self):
        #This test is ok

        #try to load object via the proxy 
        o = ProxyModel.objects.all()[0]
        
        #verify location gets resolved
        self.assertTrue(o.location)
