from django.core.exceptions import ImproperlyConfigured
from django.http import HttpResponseRedirect
from django.views.generic.detail import SingleObjectTemplateResponseMixin
from django.views.generic.edit import ModelFormMixin, ProcessFormView

class SafeModelFormMixin(ModelFormMixin):
    def create_new(self):
        pk = self.kwargs.get('pk', None)
        slug = self.kwargs.get('slug', None)
        return not (pk or slug)
    
    def get_object(self, *args, **kwargs):
        if self.create_new():
            return None
        else:
            return super(SafeModelFormMixin, self).get_object(*args, **kwargs)

class BaseModelFormView(SafeModelFormMixin, ProcessFormView):
    """
    Base view for an object instance.

    Using this base class requires subclassing to provide a response mixin.
    """
    
    action_name = 'action'
    
    def get(self, request, *args, **kwargs):
        self.object = self.get_object()
        return super(BaseModelFormView, self).get(request, *args, **kwargs)

    def post(self, request, *args, **kwargs):
        if self.action_name and request.POST.has_key(self.action_name):
            if request.POST[self.action_name].lower() == 'delete':
                return self.delete(request, *args, **kwargs)
        self.object = self.get_object()
        return super(BaseModelFormView, self).post(request, *args, **kwargs)

    # PUT is a valid HTTP verb for creating (with a known URL) or editing an
    # object, note that browsers only support POST for now.
    def put(self, *args, **kwargs):
        return self.post(*args, **kwargs)

    def delete(self, request, *args, **kwargs):
        self.object = self.get_object()
        self.object.delete()
        return HttpResponseRedirect(self.get_success_url())
    
    def get_success_url(self):
        if self.success_url:
            return self.success_url
        else:
            raise ImproperlyConfigured(
                "No URL to redirect to. Provide a success_url.")

class ModelFormView(SingleObjectTemplateResponseMixin, BaseModelFormView):
    """
    View for creating an new object instance,
    with a response rendered by template.
    """
    template_name_suffix = '_form'
