# -*- coding: utf-8 -*-
# Tests for the contrib/localflavor/ IN form fields.
tests = r"""
# INPhoneNumberField ##########################################################

INPhoneNumberField validates that the data is a valid Indian phone number,
including the STD code. It's normalised to 0XXX-XXXXXXX or 0XXX XXXXXXX format. The first 
string is the STD code which is a '0' followed by 2-4 digits. The second string
is 8 digits if the STD code is 3 digits, 7 digits if the STD code is 4 digits and
6 digits if the STD code is 5 digits. The second string will start with numbers 
between 1 and 6. The separator is either a space or a hyphen.
>>> from django.contrib.localflavor.in_.forms import INPhoneNumberField
>>> f = INPhoneNumberField()
>>> f.clean('04-2443667')
Traceback (most recent call last):
...
ValidationError: [u'Phone numbers must be in 02X-7X or 03X-6X or 04X-5X format.']
>>> f.clean('423-2443667')
Traceback (most recent call last):
...
ValidationError: [u'Phone numbers must be in 02X-7X or 03X-6X or 04X-5X format.']
>>> f.clean('0423-9442667')
Traceback (most recent call last):
...
ValidationError: [u'Phone numbers must be in 02X-7X or 03X-6X or 04X-5X format.']
>>> f.clean('0423-0443667')
Traceback (most recent call last):
...
ValidationError: [u'Phone numbers must be in 02X-7X or 03X-6X or 04X-5X format.']
>>> f.clean('0423-244366')
Traceback (most recent call last):
...
ValidationError: [u'Phone numbers must be in 02X-7X or 03X-6X or 04X-5X format.']
>>> f.clean('04232442667')
Traceback (most recent call last):
...
ValidationError: [u'Phone numbers must be in 02X-7X or 03X-6X or 04X-5X format.']
>>> f.clean('0423-2443667')
u'0423-2443667'
>>> f.clean('0423 2443667')
u'0423 2443667'
>>> f.clean('04236-2443667')
u'04236-2443667'
>>> f.clean('040-2443667')
u'040-2443667'
>>> f.clean(None)
Traceback (most recent call last):
...
ValidationError: [u'This field is required.']
>>> f.clean('')
Traceback (most recent call last):
...
ValidationError: [u'This field is required.']

>>> f = INPhoneNumberField(required=False)
>>> f.clean('04-2443667')
Traceback (most recent call last):
...
ValidationError: [u'Phone numbers must be in 02X-7X or 03X-6X or 04X-5X format.']
>>> f.clean('423-2443667')
Traceback (most recent call last):
...
ValidationError: [u'Phone numbers must be in 02X-7X or 03X-6X or 04X-5X format.']
>>> f.clean('0423-9442667')
Traceback (most recent call last):
...
ValidationError: [u'Phone numbers must be in 02X-7X or 03X-6X or 04X-5X format.']
>>> f.clean('0423-0443667')
Traceback (most recent call last):
...
ValidationError: [u'Phone numbers must be in 02X-7X or 03X-6X or 04X-5X format.']
>>> f.clean('0423-244366')
Traceback (most recent call last):
...
ValidationError: [u'Phone numbers must be in 02X-7X or 03X-6X or 04X-5X format.']
>>> f.clean('04232442667')
Traceback (most recent call last):
...
ValidationError: [u'Phone numbers must be in 02X-7X or 03X-6X or 04X-5X format.']
>>> f.clean('0423-2443667')
u'0423-2443667'
>>> f.clean('0423 2443667')
u'0423 2443667'
>>> f.clean('04236-244366')
u'04236-2443667'
>>> f.clean('040-24436678')
u'040-24436678'
>>> f.clean(None)
u''
>>> f.clean('')
u''
"""
