from django.contrib.auth.models import User
from django.db import models


class Event(models.Model):
    title = models.CharField(max_length=50)
    invitees = models.ManyToManyField(User, through='Invite', through_fields=(None, 'invitee'), related_name='events_invited')


class Invite(models.Model):
    event = models.ForeignKey(Event)
    # field order is deliberately inverted. the target field is "invitee".
    inviter = models.ForeignKey(User, related_name='invites_sent')
    invitee = models.ForeignKey(User, related_name='invites')


# models to test defining a custom source field

class A(models.Model):
    name = models.CharField(max_length=50)
    users = models.ManyToManyField(User, through='B', through_fields=('a1', None))


class B(models.Model):
    user = models.ForeignKey(User)
    a2 = models.ForeignKey(A, related_name='a2_set')
    a1 = models.ForeignKey(A)
