from operator import attrgetter

from django.contrib.auth.models import User
from django.test import TestCase

from testm2mthrough.models import Event, Invite, A, B


class CustomM2MTargetThroughFieldTests(TestCase):
    def setUp(self):
        self.event = Event.objects.create(title='DjangoCon 2014')
        u1 = User.objects.create_user('u1', 'u1@example.com', '123')
        u2 = User.objects.create_user('u2', 'u2@example.com', '123')
        u3 = User.objects.create_user('u3', 'u3@example.com', '123')
        Invite.objects.create(event=self.event, inviter=u1, invitee=u2)
        Invite.objects.create(event=self.event, inviter=u1, invitee=u3)
    
    def test_relations(self):
        self.assertQuerysetEqual(self.event.invitees.order_by('username'), [
            'u2',
            'u3',
        ], attrgetter('username'))


class CustomM2MSourceThroughFieldTests(TestCase):
    def setUp(self):
        self.a1 = A.objects.create(name='A1')
        self.a2 = A.objects.create(name='A2')
        u1 = User.objects.create_user('u1', 'u1@example.com', '123')
        u2 = User.objects.create_user('u2', 'u2@example.com', '123')
        u3 = User.objects.create_user('u3', 'u3@example.com', '123')
        B.objects.create(a1=self.a1, a2=self.a2, user=u1)
        B.objects.create(a1=self.a1, a2=self.a2, user=u2)
        B.objects.create(a1=self.a1, a2=self.a2, user=u3)
    
    def test_relations(self):
        self.assertQuerysetEqual(self.a1.users.order_by('username'), [
            'u1',
            'u2',
            'u3',
        ], attrgetter('username'))
        
        self.assertQuerysetEqual(self.a2.users.order_by('username'), [
            # empty
        ], attrgetter('username'))
