from django.utils.decorators import method_decorator

def DecoratorMixin(decorator):
    """
    Convert a classic view decorator into a Mixin for use in class-based views.

    Example:

    LoginRequired = DecoratorMixin(login_required)
    CanChangeThing = DecoratorMixin(permission_required('thing.change_thing'))

    class MyView(LoginRequired, CanChangeThing, View):
        ...

    """
    class Mixin(object):
        @method_decorator(decorator)
        def dispatch(self, *args, **kwargs):
            return super(Mixin, self).dispatch(*args, **kwargs)
    # copy name and module of the decorator to the mixin class
    Mixin.__module__, Mixin.__name__ = decorator.__module__, decorator.__name__
    return Mixin
