from django import template

register = template.Library()

token_formats = {
    template.TOKEN_TEXT: '%s',
    template.TOKEN_VAR: '%s%%s%s' % (template.VARIABLE_TAG_START, template.VARIABLE_TAG_END),
    template.TOKEN_BLOCK: '%s%%s%s' % (template.BLOCK_TAG_START, template.BLOCK_TAG_END),
    template.TOKEN_COMMENT: '%s%%s%s' % (template.COMMENT_TAG_START, template.COMMENT_TAG_END),
}

@register.tag
def noparse(parser, token):
    token_num = 0
    token = parser.tokens[token_num]
    while (not (token.token_type == template.TOKEN_BLOCK and token.contents == 'endnoparse')):
        token.contents = token_formats[token.token_type] % token.contents
        token.token_type = template.TOKEN_TEXT
        token_num += 1
        token = parser.tokens[token_num]
    del parser.tokens[token_num]
    return NoParseNode()

class NoParseNode(template.Node):
    def render(self, context):
        return ''
