__test__ = {"doctest": """

>>> a1 = Author.objects.create(name='Albert Einstein')
>>> isinstance(Book.objects, CustomManager)
True
>>> isinstance(a1.book_set, CustomManager)
True

>>> b1 = Book.objects.create(author=a1, title='How to be smart',
...                          extra_arg='extra argument detected')
[extra argument detected]

>>> b2 = a1.book_set.create(title='How to program',
...                         extra_arg='extra argument detected')
[extra argument detected]

"""}


from django.db import models


class CustomManager(models.Manager):

    def create(self, **kwargs):
        print '[%s]' % kwargs.pop('extra_arg', '')
        return super(CustomManager, self).create(**kwargs)


class Author(models.Model):
    name = models.CharField(max_length=10)


class Book(models.Model):
    title = models.CharField(max_length=10)
    author = models.ForeignKey(Author)
    objects = CustomManager()
