from django.db import models

class OptionalAge(models.Model):
    name = models.CharField(max_length=25)
    age = models.PositiveIntegerField(null=True, blank=True)

from django.contrib import admin
from django.contrib.admin.views.main import ChangeList

class AllValuesFilterSpecTest(TestCase):
    
    def setUp(self):
        OptionalAge.objects.create(name='Sam', age=35)
        OptionalAge.objects.create(name='Tilk', age=135)
        OptionalAge.objects.create(name='Oneill', age=None)
    
    def testAllValuesFilterSpecTest(self):
        
        m = OptionalAgeAdmin(OptionalAge, admin.site)
        
        r = MockRequest()
        r.GET = {'age__isnull': 'True'}
        
        cl = ChangeList(r, OptionalAge, m.list_display, m.list_display_links, 
            m.list_filter, m.date_hierarchy, m.search_fields, 
            m.list_select_related, m.list_per_page, m.list_editable, m)        
        
        filterspec = cl.get_filters(r)[0][0] 
        
        choices = filterspec.choices(cl)
        self.assertEquals(choices[3].selected, True)
        self.assertContains(choices[3].query_string, 'age__isnull=True')
        
        r = MockRequest()
        r.GET = {'age': '35'}
        
        cl = ChangeList(r, OptionalAge, m.list_display, m.list_display_links, 
            m.list_filter, m.date_hierarchy, m.search_fields, 
            m.list_select_related, m.list_per_page, m.list_editable, m)        
        
        filterspec = cl.get_filters(r)[0][0] 
        
        choices = filterspec.choices(cl)
        self.assertEquals(choices[1].selected, True)
        self.assertContains(choices[1].query_string, 'age=35')
                
        r = MockRequest()
        r.GET = {'age': '135'}
        
        cl = ChangeList(r, OptionalAge, m.list_display, m.list_display_links, 
            m.list_filter, m.date_hierarchy, m.search_fields, 
            m.list_select_related, m.list_per_page, m.list_editable, m)        
        
        filterspec = cl.get_filters(r)[0][0] 
        
        choices = filterspec.choices(cl)
        self.assertEquals(choices[2].selected, True)
        self.assertContains(choices[2].query_string, 'age=135')
        
        
    def tearDown(self):
        OptionalAge.objects.all().delete()

class OptionalAgeAdmin(admin.ModelAdmin):
    list_filter = ('age',)
                    
class MockRequest(object):
    GET = {}