# encoding: cp1251
from __future__ import with_statement

from django.db import models
from decimal import Decimal
from datetime import date

class BaseDoc(models.Model):
    when = models.DateField(u"date", default=date.today)

class InvoiceDoc(BaseDoc):
    code = models.CharField(u"number", max_length=5)

    def recalc_total(self):
        self.subtotal = Decimal(0)
        for item in self.item_set.all():
            self.subtotal += item.price
        return self

##/class InvoiceDoc

class InvoiceItem(models.Model):
    doc = models.ForeignKey(InvoiceDoc, related_name='item_set')
    price = models.DecimalField(u"price", max_digits=15, decimal_places=6)

def invoicedoc_pre_save(sender, instance, **kwa):
    instance.recalc_total()

models.signals.pre_save.connect(invoicedoc_pre_save, InvoiceDoc, 0, 'opexec_invoice_doc')
