from django.test import TestCase
import models

class SimpleTest(TestCase):
    def test_get(self):
        a = models.A.objects.create()
        b = models.B.objects.create()
        c = models.C.objects.create(b=b)

        # Let's try to query for a c where b==b. Works as expected
        self.assertEquals(models.C.objects.get(b=b).b, b)

        # Uh oh, why can I query for b=a? This first one shouldn't pass
        self.assertEquals(models.C.objects.get(b=a).b, b)
        # This one should fail, but it should fail at the .get() by
        # raising an exception, I think
        self.assertEquals(models.C.objects.get(b=a).b, a)
