"""
This file demonstrates two different styles of tests (one doctest and one
unittest). These will both pass when you run "manage.py test".

Replace these with more appropriate tests for your application.
"""

from django.test import TestCase

class SimpleTest(TestCase):
    def test_basic_addition(self):
        """
        Tests that 1 + 1 always equals 2.
        """
        self.failUnlessEqual(1 + 1, 2)

__test__ = {"doctest": """
Another way to test that 1 + 1 is equal to 2.

>>> 1 + 1 == 2
True
"""}

from django.template.loader import render_to_string
import time
class PerformanceTest(TestCase):
    def test_rendering(self):
        count = 5000
        numbers = []
        for i in range(int(count)):
            numbers.append(i)

        timesum = 0
        testcount = 10
        for i in range(testcount):
                
            start_time = time.time()
            rendered = render_to_string('list.html', locals())
            end_time = time.time()        
            
            total_time = end_time - start_time 
            timesum += total_time
            
            print "Time: %.3f" % total_time

        print "Avg: %.3f" % (timesum / testcount)
