import django.db.models as dj_models
import django.contrib.admin as dj_admin
import django.contrib.contenttypes.models as dj_ct_models
import django.contrib.contenttypes.generic as dj_generic


# model classes

class ModelC(dj_models.Model):
    relation_b = dj_models.ForeignKey('ModelB')
    
    tagged_object = dj_generic.GenericForeignKey()
    content_type = dj_models.ForeignKey(dj_ct_models.ContentType)
    object_id = dj_models.PositiveIntegerField()


class ModelA(dj_models.Model):
    pass


class ModelB(dj_models.Model):
    pass


# admin classes

class ModelCInline(dj_generic.GenericTabularInline):
    model = ModelC


class ModelAAdmin(dj_admin.ModelAdmin):
    inlines = [ModelCInline]


dj_admin.site.register(ModelA, ModelAAdmin)

# remove the following line to "fix" the error
dj_admin.site.register(ModelB)
