from django.db.models import Model,CharField,ForeignKey,ManyToManyField,TextField,DateTimeField
class User(Model):
    username  = CharField(max_length=20)
    password = CharField(max_length=20)
    topics = ManyToManyField("Tag",through="UserTag")
    
    def natural_key(self):
        return (self.username,)
    
class Posting(Model):
    user = ForeignKey(User)
    text = TextField()
    time = DateTimeField()

    def natural_key(self):
        return (self.user.username,self.time)

    natural_key.dependencies=['main.User']

class Tag(Model):
    name      = CharField(max_length=20)
    postings = ManyToManyField(Posting,through="PostingTag")

    def natural_key(self):
        return (self.name,)

class PostingTag(Model):
    tag = ForeignKey(Tag)
    posting = ForeignKey(Posting)
    
    def natural_key(self):
        return (self.tag.natural_key(),self.posting.natural_key())

class UserTag(Model):
    user = ForeignKey(User)
    tag = ForeignKey(Tag)
    
    def natural_key(self):
        return (self.tag.natural_key(),self.user.natural_key())