#!/usr/bin/env python
# encoding: utf-8
import unittest

from django.utils.feedgenerator import Rss201rev2Feed


class Issue14202TestCase(unittest.TestCase):
    """
    There is a bug in django.utils.feedgenerator.Rss201rev2Feed that has been
    reported in #14202 before.

    http://code.djangoproject.com/ticket/14202

    The feed_url property is optional but required later on to write the feed.
    """
    def test_bug_reproduction(self):
        feed = Rss201rev2Feed('title', '/link/', 'descr')
        self.assertEquals(feed.feed['feed_url'], None)
        self.assertRaises(AttributeError, feed.writeString, 'utf-8')

    def test_bug_caused_by_missing_feed_url_property(self):
        feed = Rss201rev2Feed('title', '/link/', 'descr', feed_url='/feed/')
        assert feed.writeString('utf-8')


if __name__ == '__main__':
    unittest.main()
