from django import forms
from django.core.files.uploadhandler import FileUploadHandler
from django.http import HttpResponse
from django.template import Template, RequestContext


class DummyUploadHandler(FileUploadHandler):
    def receive_data_chunk(self, raw_data, start):
        pass

    def file_complete(self, file_size):
        pass


class UploadFileForm(forms.Form):
    file = forms.FileField()


def upload_file(request):
    # Raises AttributeError('You cannot alter upload handlers after the upload has been processed.')
    request.upload_handlers.insert(0, DummyUploadHandler())

    if request.method == 'POST':
        form = UploadFileForm(request.POST, request.FILES)
        if form.is_valid():
            template = Template('''
                <!DOCTYPE html>
                <title></title>
                <h1>Done</h1>
            ''')
            context = RequestContext(request)
            return HttpResponse(template.render(context))
    else:
        form = UploadFileForm()

    template = Template('''
        <!DOCTYPE html>
        <title></title>
        <form action="." enctype="multipart/form-data" method="post">
            {% csrf_token %}
            {{ form }}
            <input type="submit">
        </form>
    ''')
    context = RequestContext(request, {'form': form})
    return HttpResponse(template.render(context))
